/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CAMERA_H
#define CAMERA_H

#include "common.h"


class Camera {
public:
   Camera();

  // methods to access camera's orientation
  inline float getXRot() const { return xRot; }
  inline float getYRot() const { return yRot; }
  inline float getZRot() const { return zRot; }
  Quat getQuat() const;

  // returns camera's position
  inline const Point3& getPos() const { return pos; }

  // sets camera's position
  inline void setPos(const Point3& p) { pos = p; }

  // updates camera's position
  inline void updatePos(const Vector3& v) { pos = pos + v; }

  // methods to change orientation
  inline void updateXRot(float dtheta) { xRot += dtheta; }
  inline void updateYRot(float dtheta) { yRot += dtheta; }
  inline void updateZRot(float dtheta) { zRot += dtheta; }

  inline void setXRot(float theta) { xRot = theta; }
  inline void setYRot(float theta) { yRot = theta; }
  inline void setZRot(float theta) { zRot = theta; }

private:
   // camera position
   Point3 pos;

   // camera orientation represented by euler angles
   float xRot, yRot, zRot;
};


#endif
