/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   This program is distributed in the hope that it will be useful,       *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ENTITY_H
#define ENTITY_H

#include "common.h"

// forward declaration
class BSP;

class Entity {
public:

  enum MOVEMENT_TYPE {
    MOVEMENT_TYPE_NORMAL,
    MOVEMENT_TYPE_WALK
  };

  Entity(bool _cleanUp,
         MOVEMENT_TYPE moveType=MOVEMENT_TYPE_NORMAL):
      cleanUp(_cleanUp),
      movementType(moveType),
      pos(0.0f, 0.0f, 0.0f),
      vel(0.0f, 0.0f, 0.0f),
      acc(0.0f, 0.0f, 0.0f),
      force(0.0f, 0.0f, 0.0f),
      mass(0.0f),
      aabbExt(0.0f, 0.0f, 0.0f),
      grounded(false) { }
  virtual ~Entity() { }

  virtual void render()=0;
  virtual void update(float dt, BSP &world)=0;

  inline bool           getCleanUp()      const { return cleanUp;      }
  inline MOVEMENT_TYPE  getMovementType() const { return movementType; }
  inline const Point3&  getPos()          const { return pos;          }
  inline const Vector3& getVel()          const { return vel;          }
  inline const Vector3& getAcc()          const { return acc;          }
  inline const Vector3& getForce()        const { return force;        }
  inline float          getMass()         const { return mass;         }
  inline const Quat&    getRot()          const { return rot;          }

  inline void setPos(const Point3 &p)    { pos   = p;    }
  inline void setVel(const Vector3 &v)   { vel   = v;    }
  inline void setAcc(const Vector3 &a)   { acc   = a;    }
  inline void setForce(const Vector3 &f) { force = f;    }
  inline void setMass(float m)           { mass  = m;    }
  inline void setRot(const Quat &q)      { rot   = q;    }
  inline void setGrounded(bool g)        { grounded = g; }

  inline AABB getAABB() const { return AABB(pos, aabbExt); }

  inline bool isGrounded() const { return grounded; }
protected:
  bool cleanUp;
  MOVEMENT_TYPE movementType;
  Point3 pos;
  Vector3 vel;
  Vector3 acc;
  Vector3 force;
  float mass;
  Vector3 aabbExt;
  Quat rot;
  bool grounded;
};


#endif
