/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   This program is distributed in the hope that it will be useful,       *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FPSDEMO_H
#define FPSDEMO_H

#include "common.h"
#include "Camera.h"
#include "BSP.h"
#include "Player.h"
#include "MD5Model.h"
#include "TriangleMeshEntity.h"
#include "Video.h"

#define NUM_MD5_MODELS    1
#define NUM_MSH_MODELS    10


class FPSDemo {
public:
  FPSDemo();
  ~FPSDemo();

  void run();
private:
  void frame(float dt);
  void render(float dt);
  void renderSky();
  void renderWeapon();
  void handleKeyboard(float dt);
  void handleMouseMotion(float dt);
  void loadModels();
  void loadSounds();
  void loadMap();
  void initSkyBox();
  void headBob(const Vector3 &displacement);
  bool shouldExit();

  Camera camera;
  Player *player;
  BSP bsp;
  MD5Model md5Models[NUM_MD5_MODELS];
  //size_t stepSoundID;
  //size_t jumpGruntSoundID;
  unsigned int stepSoundStartTime;
  TriangleMesh meshes[NUM_MSH_MODELS];
  //TriangleMeshEntity *weapon;

  // for head bobbing
  float headBobPhase;
  Vector3 headOffset;

  // for sky box
  Video::Vertex skyBox[20]; // 20 vertices since there is no bottom face
  int skyBoxTextureLeft,
      skyBoxTextureRight,
      skyBoxTextureFront,
      skyBoxTextureBack,
      skyBoxTextureTop;
};


#endif
