/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "FaceContainer.h"


FaceContainer::Face::Face():
     numVerts(0),
     lightMapID(-1),
     vertices(NULL) {

}


// copy constructor
FaceContainer::Face::Face(const Face &face) {
  numVerts   = 0;
  lightMapID = face.lightMapID;

  if ( face.numVerts > 0 && face.vertices != NULL ) {
    // allocate storage for vertices
    vertices = new Video::Vertex[face.numVerts];

    if ( NULL == vertices )
      throw std::runtime_error("FaceContainer::Face::Face(): unable to "
                               "allocate storage for vertices");

    numVerts = face.numVerts;

    // copy vertices
    for ( int i=0; i < face.numVerts; i++ )
      vertices[i] = face.vertices[i];
  }
}


FaceContainer::Face::Face(int _numVerts, int _lightMapID) {
  numVerts   = 0;
  lightMapID = -1;
  vertices   = NULL;

  if ( _numVerts > 0 ) {
    vertices = new Video::Vertex[_numVerts];

    if ( vertices != NULL )
      numVerts = _numVerts;
  }

  lightMapID = _lightMapID;
}


FaceContainer::Face::~Face() {
  if ( vertices != NULL )
    delete [] vertices;
}


void FaceContainer::Face::setVertex(int i, const Video::Vertex &v) {
  if ( i >= 0 && i < numVerts )
    vertices[i] = v;
}


void FaceContainer::insertFace(const Face &face, int matID) {
  FaceBatch *batch = NULL;

  // a linear search should suffice (unless this method is being
  // called every frame and there are TONS of textures)
  for ( size_t i=0; i < batches.size(); i++ )
    if ( batches[i].matID == matID ) {
      // found batch with matching texture ids
      batch = &batches[i];
      break;
    }

  // if a batch was not found with matching texture combination,
  // create one
  if ( NULL == batch ) {
    batches.push_back( FaceBatch() );
    batch = &batches[batches.size()-1];
    batch->matID = matID;
  }

  // finally... insert face into batch
  batch->faces.push_back(face);
}
