/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FACECONTAINER_H
#define FACECONTAINER_H

#include <stdexcept>
#include <vector>
#include <cstddef>

#include "Video.h"


// associate container for vertices (associates a material id with an
// array of vertices)
class FaceContainer {
public:
  inline void clear() { batches.clear(); }

  class Face {
  public:
    Face();
    Face(const Face &face);
    Face(int _numVerts, int _lightMapID);
    ~Face();

    void setVertex(int i, const Video::Vertex &v);

    inline int getNumVerts()   const { return numVerts; }
    inline int getLightMapID() const { return lightMapID; }
    inline const Video::Vertex* getVerts() const { return vertices; }
  private:
    int numVerts;
    int lightMapID;
    Video::Vertex *vertices;
  };

  // a batch of faces - there is one for each texture/normalmap combination
  class FaceBatch {
  public:
    FaceBatch(): matID(-1) { }
    int matID;
    std::vector<Face> faces;
  };

  inline size_t getNumBatches() const { return batches.size(); }

  inline FaceBatch& getBatch(size_t i) { return batches[i]; }
  inline const FaceBatch& getBatch(int i) const { return batches[i]; }

  void insertFace(const Face &face, int matID);
protected:
  std::vector<FaceBatch> batches;
};


#endif
