/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "Frustum.h"


int Frustum::classifySphere(const Point3 &c, float r) const {
  const Plane *planes = (Plane *)this;
  int insideCount = 0;

  for ( int i=0; i < 6; i++ ) {
    float dist = planes[i].distTo(c);

    // if sphere is completely in back of plane, it's outside of frustum
    if ( dist > r )
      insideCount++;
    if ( dist <= -r )
      return OUTSIDE;
  }

  if ( 6 == insideCount )
    return INSIDE;

  // sphere is clipped by frustum
  return INTERSECTS;
}


int Frustum::classifyAABB(const AABB &aabb) const {
  // TODO: implement this
  float r = aabb.getExt().mag();

  return classifySphere( aabb.getCenter(), r*float(1.732) );
}
