/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FRUSTUM_H
#define FRUSTUM_H

#include "common.h"


// stores clipping planes of view frustum
class Frustum {
public:
  enum { OUTSIDE = -1, INTERSECTS = 0, INSIDE = 1 };

  // clipping planes
  Plane leftP,
        rightP,
        topP,
        bottomP,
        nearP, // watch out for near and far keywords!
        farP;

  int classifySphere(const Point3 &c, float r) const;
  int classifyAABB(const AABB &aabb) const;
};


#endif
