/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   This program is distributed in the hope that it will be useful,       *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MD5ENTITY_H
#define MD5ENTITY_H

#include "MD5Model.h"
#include "Entity.h"


class MD5Entity : public Entity {
public:
  MD5Entity(MD5Model *md5, bool _cleanUP);
  virtual ~MD5Entity() { }

  virtual void render();
  virtual void update(float dt, BSP &world);

protected:
  void setAnim(int animIndex, int frameIndex=0, float t=0.0f);
  void updateAnim(float dt);

  static Quat md5Rot;
  MD5Model *model;
  int currAnim;
  int currFrame;
  float animTime;
};


#endif
