/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef AABB_H
#define AABB_H

#include "Vector3.h"
#include "Point3.h"


namespace Math3D {


// an axis-aligned bounding box
template<class Real>
class AABB {
public:
  inline AABB();
  inline AABB(const Point3<Real> &_center, const Vector3<Real>& _ext);
  inline AABB(const Point3<Real>& minP, const Point3<Real>& maxP);

  inline const Point3<Real>& getCenter() const { return center; }
  inline const Vector3<Real>& getExt() const { return ext; }

  inline Point3<Real> getMin() const { return minP; }
  inline Point3<Real> getMax() const { return maxP; }

private:
  // 2 representations
  // 1) center + extents
  Point3<Real> center;
  Vector3<Real> ext;

  // 2) minP and maxP points
  Point3<Real> minP, maxP;
};


template<class Real>
inline AABB<Real>::AABB():
     center(0.0, 0.0, 0.0),
     ext(0.0, 0.0, 0.0),
     minP(0.0, 0.0, 0.0),
     maxP(0.0, 0.0, 0.0) {

}


template<class Real>
inline AABB<Real>::AABB(const Point3<Real> &_center, const Vector3<Real>& _ext):
     center(_center),
     ext(_ext),
     minP(_center - _ext),
     maxP(_center + _ext) {

}


template<class Real>
inline AABB<Real>::AABB(const Point3<Real>& _minP, const Point3<Real>& _maxP) {
  minP = _minP;
  maxP = _maxP;
  center = (minP + maxP)*Real(0.5);
  ext = maxP - center;
}

/*
template<class Real>
inline void AABB<Real>::getPlanes(Plane<Real> *planes) const {

}
*/

} // namespace Math3D


#endif
