/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef INTERSECT_H
#define INTERSECT_H

#include <cstddef>
#include "Vector3.h"
#include "Point3.h"
#include "Plane.h"
#include "AABB.h"


namespace Math3D {

///// intersection tests between primitives /////

template<class Real>
bool intersectSphereSphere(const Point3<Real> &c0, Real r0,
                           const Point3<Real> &c1, Real r1);

template<class Real>
bool intersectSphereAABB(const Point3<Real> &c, Real r, const AABB<Real> &aabb);

template<class Real>
bool intersectSphereAABB(const Point3<Real> &c, Real r, const AABB<Real> &aabb,
                         const Point3<Real> &p);

template<class Real>
bool intersectAABBAABB(const AABB<Real> &box1, const AABB<Real> &box2,
                       AABB<Real> *overlap=NULL);

} // namespace Math3D


#include "intersect.cpp"

#endif
