/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PHYSICS_H
#define PHYSICS_H

#include <vector>
#include "common.h"
#include "Entity.h"
#include "BSP.h"


class Physics {
public:
  static const Vector3 gravity;
  static const Vector3 gravityDir;
  static const float stepSize;
  static const int hitFloor;
  static const int hitWall;

  static void beginFrame(BSP &bsp);
  static void endFrame(BSP &bsp, float dt);

  static int move(Entity *entity,
                       const Vector3 &displacement,
                       const BSP &bsp,
                       float *moveDist=NULL);
  static int slideMove(Entity *entity,
                            const Vector3 &displacement,
                            const BSP &bsp,
                            float *moveDist=NULL);
  static void walkMove(Entity *entity,
                       const Vector3 &displacement,
                       const BSP &bsp);

private:
  static void exertFloorForce(Entity *entity,
                              const Vector3 &normal);
};


#endif
