/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SOUND_H
#define SOUND_H

#include <vector>
#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>


class Sound {
public:
  static void initSound();
  static void shutdownSound();

  inline static bool isInitialized() { return initialized; }
  static size_t loadSound(const char *filename);
  static void playSound(size_t soundID, int channel, int loops);
  static void stopChannel(int channel);
  static bool isChannelPlaying(int channel);

private:
  static bool initialized;
  static std::vector<Mix_Chunk *> sounds;
};


#endif
