/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TRIANGLEMESH_H
#define TRIANGLEMESH_H

#include "Video.h"


class TriangleMesh {
public:
  TriangleMesh();
  ~TriangleMesh();

  bool load(const char *filename, bool buildUnindexed=false);

  inline int getNumTris()  const { return numTris;  }
  inline int getNumVerts() const { return numVerts; }

  inline const Video::Vertex *getIndexedVerts()   const { return indexedVerts; }
  inline const unsigned int  *getIndices()        const { return indices;      }
  inline const Video::Vertex *getUnindexedVerts() const { return verts;        }

private:
  void buildNormals();
  void clear();

  int numTris;
  int numVerts;
  unsigned int *indices;
  Video::Vertex *indexedVerts;
  Video::Vertex *verts;
};


#endif
