/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef COMMON_H
#define COMMON_H

#include <cstddef>
#include <iostream>
#include <fstream>
#include <SDL/SDL.h>

#include "Math3D/numeric.h"
#include "Math3D/intersect.h"
#include "Math3D/Vector3.h"
#include "Math3D/Point3.h"
#include "Math3D/Matrix3.h"
#include "Math3D/Matrix4.h"
#include "Math3D/Plane.h"
#include "Math3D/Quat.h"
#include "Math3D/AABB.h"

#define EPSILON (1.0f/32.0f)


typedef Math3D::Vector3<float> Vector3;
typedef Math3D::Point3<float>  Point3;
typedef Math3D::Matrix3<float> Matrix3;
typedef Math3D::Matrix4<float> Matrix4;
typedef Math3D::Plane<float>   Plane;
typedef Math3D::Quat<float>    Quat;
typedef Math3D::AABB<float>    AABB;

extern std::ofstream errorLog;

#endif
