/***************************************************************************
 *   Copyright (C) 2007 by A.J. Tavakoli                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   This program is distributed in the hope that it will be useful,       *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include <cstdlib>
#include <stdexcept>

#include <SDL/SDL.h>

#include "FPSDemo.h"
#include "common.h"


std::ofstream errorLog("log.txt");


int main(int argc, char *argv[]) {
  // initialize SDL and timer subsystem
  // (video and audio subsystems are initialized in their respective
  //  classes)
  int result = SDL_Init(SDL_INIT_TIMER);

  // was SDL initialized successfully?
  if ( -1 == result ) {
    std::cerr << "unable to initialize SDL" << std::endl;
    return EXIT_FAILURE;
  }
  try {
    FPSDemo app;
    app.run();
  }
  catch ( const std::runtime_error &e ) {
    errorLog << e.what() << std::endl;
    SDL_Quit();
    return EXIT_FAILURE;
  }

  SDL_Quit();

  return EXIT_SUCCESS;
}
